<!-- : Auto Upgrade without prompts + change edition support
@title Auto Upgrade & set root=%1& set cfg=%2& echo off 
set OPTIONS=/SelfHost /Auto Upgrade /MigChoice Upgrade /Compat IgnoreWarning /MigrateDrivers All /ResizeRecoveryPartition Disable /ShowOOBE None /Telemetry Disable /CompactOS Disable /DynamicUpdate Enable /SkipSummary /Eula Accept

pushd "%~dp0"& if defined root pushd %root% 
for %%i in ("x86\" "x64\" "") do if exist "%%~isources\setupprep.exe" set "dir=%%~i"
pushd "%dir%sources" || (echo "%dir%sources" & timeout /t 5 & exit/b)
setlocal EnableDelayedExpansion

::# start sources\setup if under winpe (when booted from media)
reg query "HKLM\Software\Microsoft\Windows NT\CurrentVersion\WinPE">nul 2>nul && (start "WinPE" sources\setup.exe &exit/b)

::# elevate so that workarounds can be set under windows
fltmc>nul || (set _="%~f0" %*& powershell -nop -c start -verb runas cmd \"/d/x/rcall $env:_\"& exit/b)

::# get current version
set NT="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion"                       
for /f "tokens=2*" %%R in ('reg query %NT% /v EditionID /reg:64 2^>nul') do set "EditionID=%%S"
for /f "tokens=2*" %%R in ('reg query %NT% /v ProductName /reg:64 2^>nul') do set "ProductName=%%S"
for /f "tokens=2*" %%R in ('reg query %NT% /v CurrentBuildNumber /reg:64 2^>nul') do set "CurrentBuild=%%S"
for /f "tokens=2-3 delims=[." %%i in ('ver') do for %%s in (%%i) do set/a Version=%%s*10+%%j

::# group editions by image
set e10=CloudN & set e11=Cloud & set e12=CoreCountrySpecific & set e13=CoreSingleLanguage 
set e14=StarterN HomeBasicN HomePremiumN CoreConnectedN CoreN 
set e15=Starter  HomeBasic  HomePremium  CoreConnectedCountrySpecific CoreConnectedSingleLanguage CoreConnected Core
set e16=UltimateN ProfessionalStudentN
set e17=Ultimate  ProfessionalStudent  ProfessionalCountrySpecific ProfessionalSingleLanguage
set e18=ProfessionalEducationN ProfessionalWorkstationN ProfessionalN
set e19=ProfessionalEducation  ProfessionalWorkstation  Professional
set e20=EducationN & set e21=Education & set e22=EnterpriseN & set e23=IoTEnterprise Enterprise
set e24=EnterpriseGN EnterpriseSN & set e25=EnterpriseG  EnterpriseS  IoTEnterpriseS Embedded

::# get available images via wim_info snippet
for /l %%i in (10,1,25) do set _%%i=& for %%U in (!e%%i!) do (set _%%U=)
set "0=%~f0"& set wim=& set ext=.esd& if exist install.wim (set ext=.wim) else if exist install.swm set ext=.swm
set "wim_info=iex ([io.file]::ReadAllText($env:0)-split'#[:]wim_info')[1]; WIM_INFO install%ext%"  
for /f "tokens=1-6 delims=," %%i in ('powershell -nop -c "%wim_info% 0"') do (
  set _%%m=%%i& set _%%i=%%m& set b_%%i=%%j& set count=%%i& set wim=!wim! %%m
  for /f "tokens=1 delims=." %%K in ("%%j") do (set Build%%i=%%K)
)
echo;Windows images:%wim%

::# get preset edition in EI.cfg or PID.txt
set Name=& set EI=& set "cfg_filter=EditionID Channel OEM Retail Volume _Default VL 0 1 ^$"
if exist EI.cfg for /f "tokens=*" %%i in ('findstr /v /i /r "%cfg_filter%" EI.cfg') do set "EI=%%i"
if exist PID.txt for /f "delims=;" %%i in (PID.txt) do set %%i 2>nul
if exist product.ini for /f "tokens=1,2 delims==" %%O in (product.ini) do if not "%%P" equ "" (set pid_%%O=%%P& set %%P=%%O)
if defined Value if not defined Name call set "Name=%%%Value%%%"
set oID=%EditionID%& set nID=%EI%& if defined Name (set nID=%Name%)
if not defined nID (if defined cfg (set nID=%cfg%) else set nID=%oID%)
echo;Edition preset: %nID%

::# get upgrade matrix
set index=& set change=& set new=0
for /l %%i in (10,1,25) do for %%U in (!e%%i!) do (
  (if %nID% equ %%U set new=%%i) & (if %oID% equ %%U set old=%%i) & (if defined _%%U set _%%i=!_%%U!)
)
if %new% equ 10 set .= Cloud N     & for %%i in (22 12 13 14 20 18 10) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 11 set .= Cloud       & for %%i in (23 12 13 15 21 19 11) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 12 set .= HomeCountry & for %%i in (10 22 13 14 20 18 12) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 13 set .= HomeSingle  & for %%i in (10 22 13 14 20 18 13) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 14 set .= Home N      & for %%i in (10 12 13 22 20 18 14) do if defined _%%i (set index=!_%%i!& set change=%%i)
if %new% equ 15 set .= Home        & for %%i in (11 12 13 23 21 19 15) do if defined _%%i (set index=!_%%i!& set change=%%i)
if %new% equ 16 set .= Ultimate N  & for %%i in (10 12 13 14 20 18 16) do if defined _%%i (set index=!_%%i!& set change=%%i)
if %new% equ 17 set .= Ultimate    & for %%i in (11 12 13 15 21 19 17) do if defined _%%i (set index=!_%%i!& set change=%%i)
if %new% equ 18 set .= Pro N       & for %%i in (10 12 13 14 20 22 18) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 19 set .= Pro         & for %%i in (11 12 13 15 21 23 19) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 20 set .= Edu N       & for %%i in (10 12 13 14 22 18 20) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 21 set .= Edu         & for %%i in (11 12 13 15 23 19 21) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 22 set .= Ent N       & for %%i in (10 12 13 14 20 18 22) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 23 set .= Ent         & for %%i in (11 12 13 15 21 19 23) do if defined _%%i (set index=!_%%i!& set change=)
if %new% equ 24 set .= other N     & for %%i in (10 12 13 14 20 18 22) do if defined _%%i (set index=!_%%i!& set change=%%i)
if %new% equ 25 set .= other       & for %%i in (11 12 13 15 21 19 23) do if defined _%%i (set index=!_%%i!& set change=%%i)
if not defined index for %%i in (15 19 21) do if defined _%%i (set index=!_%%i!& set change=%%i)
if defined index set OPTIONS=%OPTIONS% /ImageIndex %index%  
if defined change for %%i in (!e%change%!) do (set change=%%i)& rem if defined pid_%%i set OPTIONS=%OPTIONS% /pkey !pid_%%i! 
echo;Edition change: %change%
echo;Selected index: %index%

::# prevent usage of MCT for intermediary upgrade in Dynamic Update (causing 7 to 19H1 instead of 7 to 11 for example) 
if "%Build1%" gtr "15063" (set OPTIONS=%OPTIONS% /UpdateMedia Decline)

::# auto upgrade with edition lie workaround to keep files and apps - all 1904x builds allow up/downgrade between them
if defined change call :rename %change%

start "auto" setupprep.exe %OPTIONS%
timeout /t 7
exit/b

:rename EditionID
set NT="HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion"
(reg query %NT% /v ProductName_undo      /reg:32 || reg add %NT% /v ProductName_undo /d "%ProductName%" /f /reg:32
 reg query %NT% /v ProductName_undo      /reg:64 || reg add %NT% /v ProductName_undo /d "%ProductName%" /f /reg:64
 reg query %NT% /v EditionID_undo        /reg:32 || reg add %NT% /v EditionID_undo   /d "%EditionID%"   /f /reg:32
 reg query %NT% /v EditionID_undo        /reg:64 || reg add %NT% /v EditionID_undo   /d "%EditionID%"   /f /reg:64
 reg add   %NT% /v EditionID /d "%~1" /f /reg:32 &  reg add %NT% /v ProductName      /d "%~1"           /f /reg:32
 reg add   %NT% /v EditionID /d "%~1" /f /reg:64 &  reg add %NT% /v ProductName      /d "%~1"           /f /reg:64
) >nul 2>nul &exit/b

#:wim_info # 
function WIM_INFO ($file = 'install.esd', $index = 0, $output = 0) { :info while ($true) {
  #:: Quick ISO ESD WIM info by AveYo v1
  #:: args = file, image index or 0 for all, output 0 for simple, 1 for xml text, 2 for xml object
  #:: by default returns simple image index, version, arch, lang, edition - example: 6,19041.631,x64,en-US,Professional
  $block = 2097152; $bytes = new-object "Byte[]" ($block); $begin = [uint64]0; $final = [uint64]0; $limit = [uint64]0
  $steps = [int]([uint64]([IO.FileInfo]$file).Length / $block - 1); $encoding = [Text.Encoding]::GetEncoding(28591)
  $find1 = $encoding.GetString([Text.Encoding]::Unicode.GetBytes("</INSTALLATIONTYPE>"))
  $find2 = $encoding.GetString([Text.Encoding]::Unicode.GetBytes("</WIM>"))
  $f = new-object IO.FileStream ($file, 3, 1, 1); $p = 0; $p = $f.Seek(0, 2)
  for ($o = 1; $o -le $steps; $o++) { 
    $p = $f.Seek(-$block, 1); $r = $f.Read($bytes, 0, $block); if ($r -ne $block) {write-host invalid block $r; break}
    $u = [Text.Encoding]::GetEncoding(28591).GetString($bytes); $t = $u.LastIndexOf($find1, [StringComparison]::Ordinal) 
    if ($t -ge 0) {
      $f.Seek(($t -$block), 1) >''
      for ($o = 1; $o -le $block; $o++) { $f.Seek(-2, 1) >''; if ($f.ReadByte() -eq 0xfe) {$begin = $f.Position; break} }
      $limit = $f.Length - $begin; if ($limit -lt $block) {$x = $limit} else {$x = $block}
      $bytes = new-object "Byte[]" ($x); $r = $f.Read($bytes, 0, $x); 
      $u = [Text.Encoding]::GetEncoding(28591).GetString($bytes); $t = $u.IndexOf($find2, [StringComparison]::Ordinal)
      if ($t -ge 0) {$f.Seek(($t + 12 -$x), 1) >''; $final = $f.Position} ; break
    } else { $p = $f.Seek(-$block, 1)} 
  }
  if ($begin -gt 0 -and $final -gt $begin) {
    $x = $final - $begin; $f.Seek(-$x, 1) >''; $bytes = new-object "Byte[]" ($x); $r = $f.Read($bytes, 0, $x)
    if ($r -ne $x) {break}
    [xml]$xml = [Text.Encoding]::Unicode.GetString($bytes); $f.Dispose()
  } else {$f.Dispose()}
  break :info } 
  if ($output -eq 0) {$simple = ""; foreach ($i in $xml.WIM.IMAGE) { if ($index -gt 0 -and $($i.INDEX) -ne $index) {continue}
    $simple += "$($i.INDEX),$($I.WINDOWS.VERSION.BUILD).$($I.WINDOWS.VERSION.SPBUILD),"
    $simple += "$(('x64','x86')[$I.WINDOWS.ARCH-eq'0']),$($I.WINDOWS.LANGUAGES.LANGUAGE),$($I.WINDOWS.EDITIONID)`r`n"
  } ; return $simple }
  if ($output -eq 1) {[console]::OutputEncoding=[Text.Encoding]::UTF8; $xml.Save([Console]::Out); ""} 
  if ($output -eq 2) {return $xml}
}
#:: done #:wim_info
